<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Assignment Accountability - Never Miss a Deadline</title>
    <meta name="description" content="Stay on top of your assignments with automated reminders, smart planning, and accountability features.">
    @if(file_exists(public_path('build/manifest.json')))
            @vite(['resources/css/app.css', 'resources/js/app.js'])
        @else
        <script src="https://cdn.tailwindcss.com"></script>
        <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
        @endif
    </head>
<body class="bg-gradient-to-br from-blue-50 to-indigo-100 min-h-screen">
    <div class="min-h-screen flex flex-col">
        <!-- Navigation -->
        <nav class="bg-white shadow-sm">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center h-16">
                    <div class="flex items-center">
                        <h1 class="text-2xl font-bold text-blue-600">📚 Assignment Accountability</h1>
                    </div>
                    <div class="flex items-center space-x-4">
                        <a href="{{ route('login') }}" class="text-gray-700 hover:text-blue-600 px-4 py-2 rounded-md text-sm font-medium">
                            Sign In
                        </a>
                        <a href="{{ route('register') }}" class="bg-blue-600 text-white hover:bg-blue-700 px-4 py-2 rounded-md text-sm font-medium">
                            Get Started Free
                        </a>
                    </div>
                </div>
            </div>
                </nav>

        <!-- Hero Section -->
        <main class="flex-1">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
                <div class="text-center">
                    <h2 class="text-4xl md:text-5xl font-extrabold text-gray-900 mb-6">
                        Never Miss an Assignment Again
                    </h2>
                    <p class="text-xl text-gray-600 mb-8 max-w-2xl mx-auto">
                        Stay organized, meet deadlines, and achieve academic success with our intelligent assignment tracking system.
                    </p>
                    <div class="flex flex-col sm:flex-row gap-4 justify-center">
                        <a href="{{ route('register') }}" class="bg-blue-600 text-white px-8 py-3 rounded-lg text-lg font-semibold hover:bg-blue-700 transition">
                            Start Free Trial
                        </a>
                        <a href="{{ route('login') }}" class="bg-white text-blue-600 border-2 border-blue-600 px-8 py-3 rounded-lg text-lg font-semibold hover:bg-blue-50 transition">
                            Sign In
                        </a>
                    </div>
                </div>

                <!-- Features Grid -->
                <div class="mt-20 grid grid-cols-1 md:grid-cols-3 gap-8">
                    <div class="bg-white p-6 rounded-lg shadow-md">
                        <div class="text-4xl mb-4">📅</div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">Weekly Planner</h3>
                        <p class="text-gray-600">See all your assignments and study sessions at a glance. Plan your week effectively.</p>
                    </div>
                    <div class="bg-white p-6 rounded-lg shadow-md">
                        <div class="text-4xl mb-4">🔔</div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">Smart Reminders</h3>
                        <p class="text-gray-600">Get notified before study sessions and deadlines. Never miss important dates.</p>
                    </div>
                    <div class="bg-white p-6 rounded-lg shadow-md">
                        <div class="text-4xl mb-4">⚡</div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">Auto Carry-Over</h3>
                        <p class="text-gray-600">Missed a study session? We automatically reschedule it for you. Stay on track effortlessly.</p>
                    </div>
                </div>

                <!-- How It Works -->
                <div class="mt-20">
                    <h3 class="text-3xl font-bold text-center text-gray-900 mb-12">How It Works</h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                        <div class="text-center">
                            <div class="bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                                <span class="text-2xl font-bold text-blue-600">1</span>
                            </div>
                            <h4 class="text-lg font-semibold text-gray-900 mb-2">Add Your Assignments</h4>
                            <p class="text-gray-600">Enter your assignments with due dates and planned study times.</p>
                        </div>
                        <div class="text-center">
                            <div class="bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                                <span class="text-2xl font-bold text-blue-600">2</span>
                            </div>
                            <h4 class="text-lg font-semibold text-gray-900 mb-2">Plan Your Week</h4>
                            <p class="text-gray-600">View your weekly planner to see what's due and when to study.</p>
                        </div>
                        <div class="text-center">
                            <div class="bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                                <span class="text-2xl font-bold text-blue-600">3</span>
                            </div>
                            <h4 class="text-lg font-semibold text-gray-900 mb-2">Stay Accountable</h4>
                            <p class="text-gray-600">Get reminders, track progress, and never miss a deadline.</p>
                        </div>
                    </div>
        </div>

                <!-- CTA Section -->
                <div class="mt-20 bg-blue-600 rounded-lg p-12 text-center">
                    <h3 class="text-3xl font-bold text-white mb-4">Ready to Take Control?</h3>
                    <p class="text-xl text-blue-100 mb-8">Start your 14-day free trial today. No credit card required.</p>
                    <a href="{{ route('register') }}" class="bg-white text-blue-600 px-8 py-3 rounded-lg text-lg font-semibold hover:bg-gray-100 transition inline-block">
                        Get Started Now
                    </a>
                </div>
            </div>
        </main>

        <!-- Footer -->
        <footer class="bg-white border-t mt-20">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
                <div class="text-center text-gray-600">
                    <p>&copy; {{ date('Y') }} Assignment Accountability. All rights reserved.</p>
                </div>
            </div>
        </footer>
    </div>
    </body>
</html>
