@extends('layouts.app')

@section('title', 'Weekly Planner')
@section('page-title', 'This Week')

@section('content')
<div class="max-w-7xl mx-auto">
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900 mb-2">This Week</h1>
        <p class="text-gray-600">Your assignments and study sessions for this week</p>
    </div>

    <!-- Overdue Assignments (High Priority) -->
    @if($overdue->count() > 0)
    <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded">
        <h2 class="text-lg font-semibold text-red-800 mb-3">⚠️ Overdue Assignments</h2>
        <div class="space-y-3">
            @foreach($overdue as $assignment)
            <div class="bg-white p-4 rounded-lg shadow-sm border border-red-200">
                <div class="flex items-start justify-between">
                    <div class="flex-1">
                        <h3 class="font-semibold text-gray-900">{{ $assignment->assignment_title }}</h3>
                        <p class="text-sm text-gray-600 mt-1">{{ $assignment->module_name }} • {{ $assignment->tutor_name }}</p>
                        <p class="text-sm text-red-600 mt-2">
                            Due: {{ $assignment->due_date->format('M d, Y') }} 
                            ({{ $assignment->due_date->diffForHumans() }})
                        </p>
                    </div>
                    <form action="{{ route('assignments.complete', $assignment) }}" method="POST" class="ml-4">
                        @csrf
                        <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 text-sm">
                            Mark Complete
                        </button>
                    </form>
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif

    <!-- Due This Week -->
    <div class="mb-6">
        <h2 class="text-lg font-semibold text-gray-900 mb-3">Due This Week</h2>
        @if($dueThisWeek->count() > 0)
        <div class="space-y-3">
            @foreach($dueThisWeek as $assignment)
            <div class="bg-white p-4 rounded-lg shadow-sm border border-gray-200">
                <div class="flex items-start justify-between">
                    <div class="flex-1">
                        <h3 class="font-semibold text-gray-900">{{ $assignment->assignment_title }}</h3>
                        <p class="text-sm text-gray-600 mt-1">{{ $assignment->module_name }} • {{ $assignment->tutor_name }}</p>
                        <p class="text-sm text-blue-600 mt-2">
                            Due: {{ $assignment->due_date->format('M d, Y') }}
                        </p>
                    </div>
                    <form action="{{ route('assignments.complete', $assignment) }}" method="POST" class="ml-4">
                        @csrf
                        <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 text-sm">
                            Complete
                        </button>
                    </form>
                </div>
            </div>
            @endforeach
        </div>
        @else
        <p class="text-gray-500">No assignments due this week.</p>
        @endif
    </div>

    <!-- Planned Study Sessions This Week -->
    <div class="mb-6">
        <h2 class="text-lg font-semibold text-gray-900 mb-3">Planned Study Sessions</h2>
        @if($plannedThisWeek->count() > 0)
        <div class="space-y-3">
            @foreach($plannedThisWeek as $assignment)
            <div class="bg-white p-4 rounded-lg shadow-sm border border-gray-200">
                <div class="flex items-start justify-between">
                    <div class="flex-1">
                        <h3 class="font-semibold text-gray-900">{{ $assignment->assignment_title }}</h3>
                        <p class="text-sm text-gray-600 mt-1">{{ $assignment->module_name }}</p>
                        <p class="text-sm text-purple-600 mt-2">
                            📅 {{ $assignment->planned_study_day->format('M d, Y') }} 
                            at {{ $assignment->planned_study_time->format('g:i A') }}
                        </p>
                    </div>
                    <a href="{{ route('assignments.edit', $assignment) }}" class="ml-4 px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 text-sm">
                        Edit
                    </a>
                </div>
            </div>
            @endforeach
        </div>
        @else
        <p class="text-gray-500">No study sessions planned this week.</p>
        @endif
    </div>

    <!-- Quick Actions -->
    <div class="mt-8">
        <a href="{{ route('assignments.create') }}" class="inline-flex items-center px-6 py-3 bg-blue-600 text-white font-semibold rounded-lg hover:bg-blue-700">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
            </svg>
            Add New Assignment
        </a>
    </div>
</div>
@endsection
