@extends('layouts.app')

@section('title', 'Subscription')
@section('page-title', 'Subscription Management')

@section('content')
<div class="max-w-6xl mx-auto">
    <!-- Current Subscription Status -->
    <div class="bg-white shadow-md rounded-lg p-6 mb-6">
        <h2 class="text-2xl font-semibold text-gray-900 mb-4">Current Subscription</h2>
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-600 mb-1">Status</p>
                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold {{ $user->subscription_status === 'paid' ? 'bg-green-100 text-green-800' : ($user->subscription_status === 'trial' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800') }}">
                    {{ ucfirst($user->subscription_status) }}
                </span>
            </div>
            @if($user->isInTrial())
            <div>
                <p class="text-sm text-gray-600 mb-1">Trial Expires</p>
                <p class="text-lg font-semibold text-gray-900">{{ $user->trial_expiry_date->format('M d, Y') }}</p>
                <p class="text-xs text-gray-500">{{ $user->trial_expiry_date->diffForHumans() }}</p>
            </div>
            @endif
        </div>
    </div>

    <!-- Available Subscription Plans -->
    @if($plans->count() > 0)
    <div class="mb-6">
        <h2 class="text-2xl font-semibold text-gray-900 mb-4">Available Plans</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach($plans as $plan)
            <div class="bg-white shadow-md rounded-lg p-6 border-2 {{ 
                ($user->subscription_status === 'free' && $plan->slug === 'free') || 
                ($user->subscription_status === 'trial' && $plan->price > 0) ||
                ($user->subscription_status === 'paid' && $plan->price > 0)
                ? 'border-blue-500' : 'border-gray-200' 
            }}">
                <div class="text-center mb-4">
                    <h3 class="text-xl font-bold text-gray-900 mb-2">{{ $plan->name }}</h3>
                    <div class="text-3xl font-bold text-gray-900 mb-1">
                        {{ $plan->formatted_price }}
                    </div>
                    <p class="text-sm text-gray-500">
                        @if($plan->price == 0)
                            Forever
                        @else
                            Per month
                        @endif
                    </p>
                    @if($plan->trial_days > 0 && $plan->price > 0)
                        <p class="text-xs text-blue-600 mt-1">{{ $plan->trial_days }}-day trial</p>
                    @endif
                </div>

                @if($plan->description)
                <p class="text-sm text-gray-600 mb-4 text-center">{{ $plan->description }}</p>
                @endif

                @if($plan->features && count($plan->features) > 0)
                <ul class="space-y-2 mb-6">
                    @php
                        $featureLabels = [
                            'view_assignments' => 'View Assignments',
                            'add_assignments' => 'Add Assignments',
                            'view_deadlines' => 'View Deadlines, Modules & Tutors',
                            'automated_reminders' => 'Automated Reminders',
                            'carry_over_automation' => 'Auto Carry-Over Missed Sessions',
                            'whatsapp_notifications' => 'WhatsApp Notifications',
                            'weekly_risk_warnings' => 'Weekly Risk Warnings',
                            'customizable_quiet_hours' => 'Customizable Quiet Hours',
                            'in_app_notifications' => 'In-App Notifications',
                            'assignment_history' => 'Assignment History & Tracking',
                        ];
                    @endphp
                    @foreach($plan->features as $featureKey)
                        @if(isset($featureLabels[$featureKey]))
                        <li class="flex items-start text-sm text-gray-600">
                            <svg class="w-5 h-5 text-green-500 mr-2 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            <span>{{ $featureLabels[$featureKey] }}</span>
                        </li>
                        @endif
                    @endforeach
                </ul>
                @endif

                <!-- Plan Action Button -->
                <div>
                    @if($plan->price == 0 && $user->subscription_status === 'free')
                        <button disabled class="w-full px-4 py-2 bg-gray-300 text-gray-600 rounded-lg cursor-not-allowed">
                            Current Plan
                        </button>
                    @elseif($user->subscription_status === 'trial' && $plan->price > 0)
                        <form method="POST" action="{{ route('subscription.select-plan') }}">
                            @csrf
                            <input type="hidden" name="plan_id" value="{{ $plan->id }}">
                            <button type="submit" class="w-full px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                                @if($plan->trial_days > 0)
                                    Start {{ $plan->trial_days }}-Day Trial
                                @else
                                    Upgrade to {{ $plan->name }}
                                @endif
                            </button>
                        </form>
                    @elseif($user->subscription_status === 'paid' && $plan->price > 0)
                        @if($plan->slug === 'free')
                            <form method="POST" action="{{ route('profile.cancel-subscription') }}" onsubmit="return confirm('Are you sure you want to cancel your subscription? You will lose access to premium features.');">
                                @csrf
                                @method('PUT')
                                <button type="submit" class="w-full px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">
                                    Cancel Subscription
                                </button>
                            </form>
                        @else
                            <form method="POST" action="{{ route('subscription.select-plan') }}">
                                @csrf
                                <input type="hidden" name="plan_id" value="{{ $plan->id }}">
                                <button type="submit" class="w-full px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                                    Switch to {{ $plan->name }}
                                </button>
                            </form>
                        @endif
                    @elseif($user->subscription_status === 'free' && $plan->price > 0)
                        <form method="POST" action="{{ route('subscription.select-plan') }}">
                            @csrf
                            <input type="hidden" name="plan_id" value="{{ $plan->id }}">
                            <button type="submit" class="w-full px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                                @if($plan->trial_days > 0)
                                    Start {{ $plan->trial_days }}-Day Trial
                                @else
                                    Upgrade to {{ $plan->name }}
                                @endif
                            </button>
                        </form>
                    @endif
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @else
    <!-- Fallback to default plans if no plans in database -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
        <!-- Free Plan -->
        <div class="bg-white shadow-md rounded-lg p-6 border-2 {{ $user->subscription_status === 'free' ? 'border-blue-500' : 'border-gray-200' }}">
            <div class="text-center mb-4">
                <h3 class="text-xl font-bold text-gray-900 mb-2">Free Plan</h3>
                <div class="text-3xl font-bold text-gray-900 mb-1">$0</div>
                <p class="text-sm text-gray-500">Forever</p>
            </div>
            <ul class="space-y-2 mb-6">
                <li class="flex items-center text-sm text-gray-600">
                    <svg class="w-5 h-5 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                    View and add assignments
                </li>
                <li class="flex items-center text-sm text-gray-600">
                    <svg class="w-5 h-5 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                    View deadlines and modules
                </li>
                <li class="flex items-center text-sm text-gray-400">
                    <svg class="w-5 h-5 text-gray-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                    Automated reminders
                </li>
            </ul>
            @if($user->subscription_status === 'free')
                <button disabled class="w-full px-4 py-2 bg-gray-300 text-gray-600 rounded-lg cursor-not-allowed">
                    Current Plan
                </button>
            @endif
        </div>

        <!-- Premium Plan -->
        <div class="bg-white shadow-md rounded-lg p-6 border-2 {{ $user->canReceiveAutomatedFeatures() ? 'border-blue-500' : 'border-gray-200' }}">
            <div class="text-center mb-4">
                <h3 class="text-xl font-bold text-gray-900 mb-2">Premium Plan</h3>
                <div class="text-3xl font-bold text-gray-900 mb-1">$9.99</div>
                <p class="text-sm text-gray-500">Per month</p>
            </div>
            <ul class="space-y-2 mb-6">
                <li class="flex items-center text-sm text-gray-600">
                    <svg class="w-5 h-5 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                    Everything in Free Plan
                </li>
                <li class="flex items-center text-sm text-gray-600">
                    <svg class="w-5 h-5 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                    Automated reminders
                </li>
                <li class="flex items-center text-sm text-gray-600">
                    <svg class="w-5 h-5 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                    Auto carry-over missed sessions
                </li>
                <li class="flex items-center text-sm text-gray-600">
                    <svg class="w-5 h-5 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                    WhatsApp notifications
                </li>
            </ul>
            @if($user->canReceiveAutomatedFeatures())
                @if($user->subscription_status === 'paid')
                    <form method="POST" action="{{ route('profile.cancel-subscription') }}" onsubmit="return confirm('Are you sure you want to cancel your subscription?');">
                        @csrf
                        @method('PUT')
                        <button type="submit" class="w-full px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">
                            Cancel Subscription
                        </button>
                    </form>
                @else
                    <button type="button" onclick="alert('Upgrade functionality will be integrated with your payment gateway.');" class="w-full px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                        Upgrade to Premium
                    </button>
                @endif
            @else
                <button type="button" onclick="alert('Upgrade functionality will be integrated with your payment gateway.');" class="w-full px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                    Upgrade to Premium
                </button>
            @endif
        </div>
    </div>
    @endif

    <!-- Feature Comparison -->
    @if($plans->count() > 0)
    <div class="bg-white shadow-md rounded-lg p-6">
        <h2 class="text-xl font-semibold text-gray-900 mb-4">Feature Comparison</h2>
        <div class="overflow-x-auto">
            @php
                // Feature labels mapping
                $featureLabels = [
                    'view_assignments' => 'View Assignments',
                    'add_assignments' => 'Add Assignments',
                    'view_deadlines' => 'View Deadlines, Modules & Tutors',
                    'automated_reminders' => 'Automated Reminders',
                    'carry_over_automation' => 'Auto Carry-Over Missed Sessions',
                    'whatsapp_notifications' => 'WhatsApp Notifications',
                    'weekly_risk_warnings' => 'Weekly Risk Warnings',
                    'customizable_quiet_hours' => 'Customizable Quiet Hours',
                    'in_app_notifications' => 'In-App Notifications',
                    'assignment_history' => 'Assignment History & Tracking',
                ];

                // Collect all unique features from all plans
                $allFeatures = [];
                foreach ($plans as $plan) {
                    if ($plan->features && is_array($plan->features)) {
                        foreach ($plan->features as $feature) {
                            if (!in_array($feature, $allFeatures)) {
                                $allFeatures[] = $feature;
                            }
                        }
                    }
                }
                // Sort features to maintain consistent order
                sort($allFeatures);
            @endphp

            @if(count($allFeatures) > 0)
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Feature</th>
                        @foreach($plans as $plan)
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">
                            {{ $plan->name }}
                            <div class="text-xs font-normal text-gray-400 mt-1">{{ $plan->formatted_price }}</div>
                        </th>
                        @endforeach
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($allFeatures as $featureKey)
                        @if(isset($featureLabels[$featureKey]))
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $featureLabels[$featureKey] }}
                            </td>
                            @foreach($plans as $plan)
                            <td class="px-6 py-4 whitespace-nowrap text-center">
                                @if($plan->features && is_array($plan->features) && in_array($featureKey, $plan->features))
                                    <svg class="w-5 h-5 text-green-500 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                    </svg>
                                @else
                                    <svg class="w-5 h-5 text-red-500 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                    </svg>
                                @endif
                            </td>
                            @endforeach
                        </tr>
                        @endif
                    @endforeach
                </tbody>
            </table>
            @else
            <div class="text-center py-8 text-gray-500">
                <p>No features configured for any plans yet.</p>
                <p class="text-sm mt-2">Please configure features in the admin panel.</p>
            </div>
            @endif
        </div>
    </div>
    @endif
</div>
@endsection
