@extends('layouts.app')

@section('title', 'Profile')
@section('page-title', 'Profile Settings')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- Profile Information -->
        <div class="bg-white shadow-md rounded-lg p-6">
            <h2 class="text-xl font-semibold text-gray-900 mb-4">Profile Information</h2>
            <form method="POST" action="{{ route('profile.update') }}">
                @csrf
                @method('PUT')
                <div class="space-y-4">
                    <div>
                        <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Name</label>
                        <input type="text" id="name" name="name" value="{{ old('name', $user->name) }}" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-700 mb-2">Email</label>
                        <input type="email" id="email" name="email" value="{{ old('email', $user->email) }}" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                    <div>
                        <label for="phone" class="block text-sm font-medium text-gray-700 mb-2">Phone (for WhatsApp notifications)</label>
                        <input type="text" id="phone" name="phone" value="{{ old('phone', $user->phone) }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <p class="mt-1 text-sm text-gray-500">Required for WhatsApp notifications (paid/trial only)</p>
                    </div>
                    <button type="submit" class="w-full px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                        Update Profile
                    </button>
                </div>
            </form>
        </div>

        <!-- Subscription & Preferences -->
        <div class="space-y-6">
            <!-- Subscription Status -->
            <div class="bg-white shadow-md rounded-lg p-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Subscription</h2>
                <div class="space-y-3">
                    <div>
                        <p class="text-sm text-gray-600">Status: <span class="font-semibold capitalize px-2 py-1 rounded {{ $user->subscription_status === 'paid' ? 'bg-green-100 text-green-800' : ($user->subscription_status === 'trial' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800') }}">{{ $user->subscription_status }}</span></p>
                        @if($user->isInTrial())
                            <p class="text-sm text-gray-600 mt-2">Trial expires: <span class="font-semibold">{{ $user->trial_expiry_date->format('M d, Y') }}</span></p>
                            <p class="text-xs text-gray-500 mt-1">{{ $user->trial_expiry_date->diffForHumans() }}</p>
                        @endif
                    </div>
                    
                    <div class="pt-4 border-t border-gray-200 space-y-2">
                        @if($user->subscription_status === 'free')
                            <button type="button" onclick="alert('Upgrade functionality will be integrated with your payment gateway (e.g., Stripe, PayPal). For now, contact support to upgrade.');" class="block w-full px-4 py-2 bg-blue-600 text-white text-center rounded-lg hover:bg-blue-700 font-medium">
                                Upgrade to Premium
                            </button>
                            <p class="text-xs text-gray-500 text-center mt-2">Get automated reminders, carry-over features, and WhatsApp notifications</p>
                        @elseif($user->subscription_status === 'trial')
                            <button type="button" onclick="alert('Upgrade functionality will be integrated with your payment gateway (e.g., Stripe, PayPal). For now, contact support to upgrade.');" class="block w-full px-4 py-2 bg-blue-600 text-white text-center rounded-lg hover:bg-blue-700 font-medium">
                                Upgrade to Paid Plan
                            </button>
                            <p class="text-xs text-gray-500 text-center mt-2">Continue enjoying premium features after trial</p>
                        @elseif($user->subscription_status === 'paid')
                            <button type="button" class="block w-full px-4 py-2 bg-red-600 text-white text-center rounded-lg hover:bg-red-700 font-medium" onclick="if(confirm('Are you sure you want to cancel your subscription? You will lose access to premium features.')) { document.getElementById('cancel-subscription-form').submit(); }">
                                Cancel Subscription
                            </button>
                            <form id="cancel-subscription-form" method="POST" action="{{ route('profile.cancel-subscription') }}" class="hidden">
                                @csrf
                                @method('PUT')
                            </form>
                            <p class="text-xs text-gray-500 text-center">Your subscription will remain active until the end of the billing period</p>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Preferences (Paid/Trial Only) -->
            @if($user->canReceiveAutomatedFeatures())
            <div class="bg-white shadow-md rounded-lg p-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Quiet Hours</h2>
                <form method="POST" action="{{ route('profile.update-preferences') }}">
                    @csrf
                    @method('PUT')
                    <div class="space-y-4">
                        <div>
                            <label for="quiet_hours_start" class="block text-sm font-medium text-gray-700 mb-2">Start Time</label>
                            <input type="time" id="quiet_hours_start" name="quiet_hours_start" value="{{ old('quiet_hours_start', $preferences ? $preferences->quiet_hours_start->format('H:i') : '18:00') }}" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label for="quiet_hours_end" class="block text-sm font-medium text-gray-700 mb-2">End Time</label>
                            <input type="time" id="quiet_hours_end" name="quiet_hours_end" value="{{ old('quiet_hours_end', $preferences ? $preferences->quiet_hours_end->format('H:i') : '08:00') }}" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <button type="submit" class="w-full px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                            Update Preferences
                        </button>
                    </div>
                </form>
            </div>
            @endif

            <!-- Change Password -->
            <div class="bg-white shadow-md rounded-lg p-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Change Password</h2>
                <form method="POST" action="{{ route('profile.update-password') }}">
                    @csrf
                    @method('PUT')
                    <div class="space-y-4">
                        <div>
                            <label for="current_password" class="block text-sm font-medium text-gray-700 mb-2">Current Password</label>
                            <input type="password" id="current_password" name="current_password" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label for="password" class="block text-sm font-medium text-gray-700 mb-2">New Password</label>
                            <input type="password" id="password" name="password" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label for="password_confirmation" class="block text-sm font-medium text-gray-700 mb-2">Confirm New Password</label>
                            <input type="password" id="password_confirmation" name="password_confirmation" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <button type="submit" class="w-full px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                            Update Password
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
