<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Onboarding - Assignment Accountability</title>
    @if(file_exists(public_path('build/manifest.json')))
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    @else
        <script src="https://cdn.tailwindcss.com"></script>
        <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    @endif
</head>
<body class="bg-gray-50 min-h-screen flex items-center justify-center py-12 px-4">
    <div class="max-w-2xl w-full bg-white rounded-lg shadow-md p-8">
        <div class="text-center mb-6">
            <h1 class="text-3xl font-bold text-blue-600 mb-2">📚 Assignment Accountability</h1>
        </div>
        <h2 class="text-3xl font-bold text-gray-900 mb-6 text-center">Welcome! Let's Get Started</h2>
        <p class="text-gray-600 mb-8">Help us understand your current situation to personalize your experience.</p>

        <form method="POST" action="{{ route('onboarding.validate-stress') }}" x-data="{ stressLevel: 5, overloadLevel: 5 }">
            @csrf
            <div class="mb-8">
                <label class="block text-sm font-medium text-gray-700 mb-3">
                    On a scale of 1-10, how stressed are you about your assignments?
                </label>
                <div class="relative">
                    <div class="mb-2">
                        <input 
                            type="range" 
                            name="stress_level" 
                            min="1" 
                            max="10" 
                            :value="stressLevel"
                            @input="stressLevel = $event.target.value"
                            class="w-full h-3 bg-gray-200 rounded-lg appearance-none cursor-pointer accent-blue-600"
                        >
                    </div>
                    <div class="flex justify-between items-center mt-3">
                        <span class="text-xs text-gray-500">1 - Not stressed</span>
                        <div class="text-center">
                            <div class="text-3xl font-bold text-blue-600 mb-1" x-text="stressLevel"></div>
                            <div class="text-xs text-gray-500">Your selection</div>
                        </div>
                        <span class="text-xs text-gray-500">10 - Very stressed</span>
                    </div>
                </div>
            </div>

            <div class="mb-8">
                <label class="block text-sm font-medium text-gray-700 mb-3">
                    On a scale of 1-10, how overloaded do you feel with your workload?
                </label>
                <div class="relative">
                    <div class="mb-2">
                        <input 
                            type="range" 
                            name="overload_level" 
                            min="1" 
                            max="10" 
                            :value="overloadLevel"
                            @input="overloadLevel = $event.target.value"
                            class="w-full h-3 bg-gray-200 rounded-lg appearance-none cursor-pointer accent-blue-600"
                        >
                    </div>
                    <div class="flex justify-between items-center mt-3">
                        <span class="text-xs text-gray-500">1 - Not overloaded</span>
                        <div class="text-center">
                            <div class="text-3xl font-bold text-blue-600 mb-1" x-text="overloadLevel"></div>
                            <div class="text-xs text-gray-500">Your selection</div>
                        </div>
                        <span class="text-xs text-gray-500">10 - Completely overloaded</span>
                    </div>
                </div>
            </div>

            <button type="submit" class="w-full px-6 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 font-semibold">
                Continue
            </button>
        </form>
    </div>
</body>
</html>
