<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Personalize - Assignment Accountability</title>
    @if(file_exists(public_path('build/manifest.json')))
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    @else
        <script src="https://cdn.tailwindcss.com"></script>
        <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    @endif
</head>
<body class="bg-gray-50 min-h-screen flex items-center justify-center py-12 px-4">
    <div class="max-w-2xl w-full bg-white rounded-lg shadow-md p-8">
        <div class="text-center mb-6">
            <h1 class="text-3xl font-bold text-blue-600 mb-2">📚 Assignment Accountability</h1>
        </div>
        <h2 class="text-3xl font-bold text-gray-900 mb-6 text-center">Tell Us About Yourself</h2>
        <p class="text-gray-600 mb-8">This helps us provide better recommendations and insights.</p>

        <form method="POST" action="{{ route('onboarding.save-personalization') }}">
            @csrf
            <div class="space-y-6">
                <div>
                    <label for="university" class="block text-sm font-medium text-gray-700 mb-2">University *</label>
                    <input type="text" id="university" name="university" required value="{{ old('university') }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                </div>

                <div>
                    <label for="course" class="block text-sm font-medium text-gray-700 mb-2">Course/Program *</label>
                    <input type="text" id="course" name="course" required value="{{ old('course') }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                </div>

                <div>
                    <label for="year_of_study" class="block text-sm font-medium text-gray-700 mb-2">Year of Study *</label>
                    <input type="number" id="year_of_study" name="year_of_study" required min="1" max="10" value="{{ old('year_of_study') }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                </div>

                <div>
                    <label for="study_habits" class="block text-sm font-medium text-gray-700 mb-2">Study Habits (Optional)</label>
                    <textarea id="study_habits" name="study_habits" rows="4" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">{{ old('study_habits') }}</textarea>
                    <p class="mt-1 text-sm text-gray-500">Tell us about your study preferences and habits</p>
                </div>
            </div>

            @if($errors->any())
                <div class="mt-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                    <ul class="list-disc list-inside">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="mt-8">
                <button type="submit" class="w-full px-6 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 font-semibold">
                    Continue
                </button>
            </div>
        </form>
    </div>
</body>
</html>
