@extends('layouts.app')

@section('title', 'Notifications')
@section('page-title', 'Notifications')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="bg-white shadow-md rounded-lg overflow-hidden">
        @if($notifications->count() > 0)
        <div class="divide-y divide-gray-200">
            @foreach($notifications as $notification)
            <div class="p-6 {{ !$notification->read ? 'bg-blue-50' : '' }}">
                <div class="flex items-start justify-between">
                    <div class="flex-1">
                        <h3 class="text-lg font-semibold text-gray-900">{{ $notification->title }}</h3>
                        <p class="text-gray-600 mt-1">{{ $notification->message }}</p>
                        <p class="text-sm text-gray-500 mt-2">{{ $notification->created_at->diffForHumans() }}</p>
                        @if($notification->assignment)
                            <a href="{{ route('assignments.show', $notification->assignment) }}" class="text-blue-600 hover:text-blue-800 text-sm mt-2 inline-block">
                                View Assignment →
                            </a>
                        @endif
                    </div>
                    @if(!$notification->read)
                    <form action="{{ route('notifications.read', $notification) }}" method="POST" class="ml-4">
                        @csrf
                        <button type="submit" class="px-3 py-1 text-sm bg-blue-600 text-white rounded hover:bg-blue-700">
                            Mark Read
                        </button>
                    </form>
                    @endif
                </div>
            </div>
            @endforeach
        </div>
        <div class="px-6 py-4 border-t border-gray-200">
            {{ $notifications->links() }}
        </div>
        @else
        <div class="p-8 text-center">
            <p class="text-gray-500">No notifications yet.</p>
        </div>
        @endif
    </div>
</div>
@endsection
