@extends('layouts.app')

@section('title', $assignment->assignment_title)
@section('page-title', 'Assignment Details')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="bg-white shadow-md rounded-lg p-6">
        <div class="flex justify-between items-start mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">{{ $assignment->assignment_title }}</h1>
                <p class="text-gray-600 mt-1">{{ $assignment->module_name }}</p>
            </div>
            <span class="px-3 py-1 rounded-full text-sm font-semibold {{ $assignment->status === 'completed' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                {{ ucfirst($assignment->status) }}
            </span>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
            <div>
                <h3 class="text-sm font-medium text-gray-500 mb-1">Tutor</h3>
                <p class="text-gray-900">{{ $assignment->tutor_name }}</p>
            </div>
            <div>
                <h3 class="text-sm font-medium text-gray-500 mb-1">Type</h3>
                <p class="text-gray-900 capitalize">{{ $assignment->assignment_type }}</p>
            </div>
            <div>
                <h3 class="text-sm font-medium text-gray-500 mb-1">Due Date</h3>
                <p class="text-gray-900 {{ $assignment->isOverdue() ? 'text-red-600 font-semibold' : '' }}">
                    {{ $assignment->due_date->format('F d, Y') }}
                    @if($assignment->isOverdue())
                        <span class="block text-sm">(Overdue)</span>
                    @endif
                </p>
            </div>
            <div>
                <h3 class="text-sm font-medium text-gray-500 mb-1">Planned Study</h3>
                <p class="text-gray-900">
                    {{ $assignment->planned_study_day->format('F d, Y') }} at {{ $assignment->planned_study_time->format('g:i A') }}
                </p>
            </div>
        </div>

        @if(in_array($assignment->assignment_type, ['formative', 'summative']))
        <div class="mb-6 p-4 bg-gray-50 rounded-lg">
            <h3 class="text-sm font-medium text-gray-500 mb-2">Week Range</h3>
            <p class="text-gray-900">Week {{ $assignment->week_start }} - Week {{ $assignment->week_end }}</p>
        </div>
        @endif

        <div class="flex space-x-4">
            @if($assignment->status === 'pending')
            <form action="{{ route('assignments.complete', $assignment) }}" method="POST">
                @csrf
                <button type="submit" class="px-6 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700">
                    Mark as Completed
                </button>
            </form>
            @endif
            <a href="{{ route('assignments.edit', $assignment) }}" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                Edit
            </a>
            <a href="{{ route('assignments.index') }}" class="px-6 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50">
                Back to List
            </a>
        </div>
    </div>
</div>
@endsection
