@extends('layouts.app')

@section('title', 'Edit Assignment')
@section('page-title', 'Edit Assignment')

@section('content')
<div class="max-w-3xl mx-auto">
    <form method="POST" action="{{ route('assignments.update', $assignment) }}" class="bg-white shadow-md rounded-lg p-6">
        @csrf
        @method('PUT')

        <div class="mb-6">
            <label for="module_name" class="block text-sm font-medium text-gray-700 mb-2">Module Name *</label>
            <input type="text" id="module_name" name="module_name" required value="{{ old('module_name', $assignment->module_name) }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
        </div>

        <div class="mb-6">
            <label for="assignment_title" class="block text-sm font-medium text-gray-700 mb-2">Assignment Title *</label>
            <input type="text" id="assignment_title" name="assignment_title" required value="{{ old('assignment_title', $assignment->assignment_title) }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
        </div>

        <div class="mb-6">
            <label for="tutor_name" class="block text-sm font-medium text-gray-700 mb-2">Tutor Name *</label>
            <input type="text" id="tutor_name" name="tutor_name" required value="{{ old('tutor_name', $assignment->tutor_name) }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
        </div>

        <div class="mb-6">
            <label for="assignment_type" class="block text-sm font-medium text-gray-700 mb-2">Assignment Type *</label>
            <select id="assignment_type" name="assignment_type" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                <option value="weekly" {{ $assignment->assignment_type === 'weekly' ? 'selected' : '' }}>Weekly</option>
                <option value="formative" {{ $assignment->assignment_type === 'formative' ? 'selected' : '' }}>Formative (Week Range)</option>
                <option value="summative" {{ $assignment->assignment_type === 'summative' ? 'selected' : '' }}>Summative (Week Range)</option>
            </select>
        </div>

        @if(in_array($assignment->assignment_type, ['formative', 'summative']))
        <div class="mb-6">
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label for="week_start" class="block text-sm font-medium text-gray-700 mb-2">Week Start *</label>
                    <input type="number" id="week_start" name="week_start" min="1" value="{{ old('week_start', $assignment->week_start) }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div>
                    <label for="week_end" class="block text-sm font-medium text-gray-700 mb-2">Week End *</label>
                    <input type="number" id="week_end" name="week_end" min="1" value="{{ old('week_end', $assignment->week_end) }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                </div>
            </div>
        </div>
        @endif

        <div class="mb-6">
            <label for="due_date" class="block text-sm font-medium text-gray-700 mb-2">Due Date *</label>
            <input type="date" id="due_date" name="due_date" required value="{{ old('due_date', $assignment->due_date->format('Y-m-d')) }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
        </div>

        <div class="mb-6">
            <label for="planned_study_day" class="block text-sm font-medium text-gray-700 mb-2">Planned Study Day *</label>
            <input type="date" id="planned_study_day" name="planned_study_day" required value="{{ old('planned_study_day', $assignment->planned_study_day->format('Y-m-d')) }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
        </div>

        <div class="mb-6">
            <label for="planned_study_time" class="block text-sm font-medium text-gray-700 mb-2">Planned Study Time *</label>
            <input type="time" id="planned_study_time" name="planned_study_time" required value="{{ old('planned_study_time', $assignment->planned_study_time->format('H:i')) }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
        </div>

        <div class="flex items-center justify-end space-x-4">
            <a href="{{ route('assignments.show', $assignment) }}" class="px-6 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50">
                Cancel
            </a>
            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                Update Assignment
            </button>
        </div>
    </form>
</div>
@endsection
