@extends('layouts.app')

@section('title', 'Add Assignment')
@section('page-title', 'Add New Assignment')

@section('content')
<div class="max-w-3xl mx-auto">
    <form method="POST" action="{{ route('assignments.store') }}" class="bg-white shadow-md rounded-lg p-6">
        @csrf

        <div class="mb-6">
            <label for="module_name" class="block text-sm font-medium text-gray-700 mb-2">Module Name *</label>
            <input type="text" id="module_name" name="module_name" required value="{{ old('module_name') }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
        </div>

        <div class="mb-6">
            <label for="assignment_title" class="block text-sm font-medium text-gray-700 mb-2">Assignment Title *</label>
            <input type="text" id="assignment_title" name="assignment_title" required value="{{ old('assignment_title') }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
        </div>

        <div class="mb-6">
            <label for="tutor_name" class="block text-sm font-medium text-gray-700 mb-2">Tutor Name *</label>
            <input type="text" id="tutor_name" name="tutor_name" required value="{{ old('tutor_name') }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
        </div>

        <div class="mb-6">
            <label for="assignment_type" class="block text-sm font-medium text-gray-700 mb-2">Assignment Type *</label>
            <select id="assignment_type" name="assignment_type" required x-data="{ type: '{{ old('assignment_type', 'weekly') }}' }" x-model="type" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                <option value="weekly">Weekly</option>
                <option value="formative">Formative (Week Range)</option>
                <option value="summative">Summative (Week Range)</option>
            </select>
        </div>

        <div x-show="assignment_type === 'formative' || assignment_type === 'summative'" x-data="{ type: $el.closest('form').querySelector('[name=assignment_type]').value }" class="mb-6" style="display: none;">
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label for="week_start" class="block text-sm font-medium text-gray-700 mb-2">Week Start *</label>
                    <input type="number" id="week_start" name="week_start" min="1" value="{{ old('week_start') }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div>
                    <label for="week_end" class="block text-sm font-medium text-gray-700 mb-2">Week End *</label>
                    <input type="number" id="week_end" name="week_end" min="1" value="{{ old('week_end') }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                </div>
            </div>
        </div>

        <div class="mb-6">
            <label for="due_date" class="block text-sm font-medium text-gray-700 mb-2">Due Date *</label>
            <input type="date" id="due_date" name="due_date" required value="{{ old('due_date') }}" min="{{ date('Y-m-d') }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            <p class="mt-1 text-sm text-gray-500">Assignments must have a due date</p>
        </div>

        <div class="mb-6">
            <label for="planned_study_day" class="block text-sm font-medium text-gray-700 mb-2">Planned Study Day *</label>
            <input type="date" id="planned_study_day" name="planned_study_day" required value="{{ old('planned_study_day') }}" min="{{ date('Y-m-d') }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            <p class="mt-1 text-sm text-gray-500">When do you plan to work on this assignment?</p>
        </div>

        <div class="mb-6">
            <label for="planned_study_time" class="block text-sm font-medium text-gray-700 mb-2">Planned Study Time *</label>
            <input type="time" id="planned_study_time" name="planned_study_time" required value="{{ old('planned_study_time') }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            <p class="mt-1 text-sm text-gray-500">What time will you start studying?</p>
        </div>

        <div class="flex items-center justify-end space-x-4">
            <a href="{{ route('weekly-planner') }}" class="px-6 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50">
                Cancel
            </a>
            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                Create Assignment
            </button>
        </div>
    </form>
</div>

<script>
document.addEventListener('alpine:init', () => {
    Alpine.data('assignmentForm', () => ({
        assignment_type: '{{ old('assignment_type', 'weekly') }}',
        init() {
            const select = document.getElementById('assignment_type');
            if (select) {
                select.addEventListener('change', (e) => {
                    this.assignment_type = e.target.value;
                });
            }
        }
    }));
});
</script>
@endsection
