@extends('layouts.admin')

@section('title', 'User Details')
@section('page-title', 'User Details')

@section('content')
<div class="max-w-7xl mx-auto">
    <div class="bg-white shadow-md rounded-lg p-6 mb-6">
        <div class="flex items-center justify-between mb-6">
            <div class="flex items-center">
                <div class="w-16 h-16 rounded-full bg-blue-500 flex items-center justify-center text-white font-bold text-2xl mr-4">
                    {{ strtoupper(substr($user->name, 0, 1)) }}
                </div>
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">{{ $user->name }}</h1>
                    <p class="text-gray-600">{{ $user->email }}</p>
                </div>
            </div>
            <div class="space-x-2">
                <span class="px-3 py-1 rounded-full text-sm font-semibold {{ $user->subscription_status === 'paid' ? 'bg-green-100 text-green-800' : ($user->subscription_status === 'trial' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800') }}">
                    {{ ucfirst($user->subscription_status) }}
                </span>
                @if($user->is_admin)
                    <span class="px-3 py-1 rounded-full text-sm font-semibold bg-purple-100 text-purple-800">Admin</span>
                @endif
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div>
                <h3 class="text-sm font-medium text-gray-500 mb-1">Phone</h3>
                <p class="text-gray-900">{{ $user->phone ?? 'Not provided' }}</p>
            </div>
            <div>
                <h3 class="text-sm font-medium text-gray-500 mb-1">Member Since</h3>
                <p class="text-gray-900">{{ $user->created_at->format('M d, Y') }}</p>
            </div>
            @if($user->isInTrial())
            <div>
                <h3 class="text-sm font-medium text-gray-500 mb-1">Trial Expires</h3>
                <p class="text-gray-900">{{ $user->trial_expiry_date->format('M d, Y') }}</p>
            </div>
            @endif
        </div>
    </div>

    <!-- User's Assignments -->
    <div class="bg-white shadow-md rounded-lg p-6 mb-6">
        <h2 class="text-xl font-semibold text-gray-900 mb-4">Assignments ({{ $user->assignments->count() }})</h2>
        @if($user->assignments->count() > 0)
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Title</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Module</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Due Date</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($user->assignments as $assignment)
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $assignment->assignment_title }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $assignment->module_name }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $assignment->due_date->format('M d, Y') }}</td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $assignment->status === 'completed' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                {{ ucfirst($assignment->status) }}
                            </span>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <p class="text-gray-500">No assignments yet.</p>
        @endif
    </div>

    <div class="flex space-x-4">
        <a href="{{ route('admin.users') }}" class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700">
            Back to Users
        </a>
        @if($user->id !== auth()->id())
        <form method="POST" action="{{ route('admin.users.toggle-admin', $user) }}" class="inline">
            @csrf
            <button type="submit" class="px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700" onclick="return confirm('Are you sure?')">
                {{ $user->is_admin ? 'Remove Admin Access' : 'Grant Admin Access' }}
            </button>
        </form>
        @endif
    </div>
</div>
@endsection
