@extends('layouts.admin')

@section('title', 'Subscription Plan Details')
@section('page-title', 'Subscription Plan: {{ $subscriptionPlan->name }}')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="bg-white shadow-md rounded-lg p-6 mb-6">
        <div class="flex justify-between items-start mb-4">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">{{ $subscriptionPlan->name }}</h1>
                <p class="text-gray-600 mt-1">{{ $subscriptionPlan->slug }}</p>
            </div>
            <div class="flex space-x-2">
                <a href="{{ route('admin.subscription-plans.edit', $subscriptionPlan) }}" class="px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700">
                    Edit
                </a>
                <form method="POST" action="{{ route('admin.subscription-plans.destroy', $subscriptionPlan) }}" class="inline" onsubmit="return confirm('Are you sure?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">
                        Delete
                    </button>
                </form>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <h3 class="text-sm font-medium text-gray-500 mb-1">Price</h3>
                <p class="text-2xl font-bold text-gray-900">{{ $subscriptionPlan->formatted_price }}</p>
            </div>
            <div>
                <h3 class="text-sm font-medium text-gray-500 mb-1">Status</h3>
                <span class="px-3 py-1 rounded-full text-sm font-semibold {{ $subscriptionPlan->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                    {{ $subscriptionPlan->is_active ? 'Active' : 'Inactive' }}
                </span>
            </div>
            <div>
                <h3 class="text-sm font-medium text-gray-500 mb-1">Trial Period</h3>
                <p class="text-lg text-gray-900">{{ $subscriptionPlan->trial_days }} days</p>
            </div>
            <div>
                <h3 class="text-sm font-medium text-gray-500 mb-1">Sort Order</h3>
                <p class="text-lg text-gray-900">{{ $subscriptionPlan->sort_order }}</p>
            </div>
        </div>

        @if($subscriptionPlan->description)
        <div class="mt-6">
            <h3 class="text-sm font-medium text-gray-500 mb-2">Description</h3>
            <p class="text-gray-900">{{ $subscriptionPlan->description }}</p>
        </div>
        @endif

        @if($subscriptionPlan->features && count($subscriptionPlan->features) > 0)
        <div class="mt-6">
            <h3 class="text-sm font-medium text-gray-500 mb-2">Features</h3>
            <ul class="space-y-2">
                @php
                    $featureLabels = [
                        'view_assignments' => 'View Assignments',
                        'add_assignments' => 'Add Assignments',
                        'view_deadlines' => 'View Deadlines, Modules & Tutors',
                        'automated_reminders' => 'Automated Reminders',
                        'carry_over_automation' => 'Auto Carry-Over Missed Sessions',
                        'whatsapp_notifications' => 'WhatsApp Notifications',
                        'weekly_risk_warnings' => 'Weekly Risk Warnings',
                        'customizable_quiet_hours' => 'Customizable Quiet Hours',
                        'in_app_notifications' => 'In-App Notifications',
                        'assignment_history' => 'Assignment History & Tracking',
                    ];
                @endphp
                @foreach($subscriptionPlan->features as $featureKey)
                    @if(isset($featureLabels[$featureKey]))
                    <li class="flex items-center text-gray-900">
                        <svg class="w-5 h-5 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                        {{ $featureLabels[$featureKey] }}
                    </li>
                    @endif
                @endforeach
            </ul>
        </div>
        @endif
    </div>

    <div class="flex justify-start">
        <a href="{{ route('admin.subscription-plans.index') }}" class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700">
            Back to Plans
        </a>
    </div>
</div>
@endsection
