@extends('layouts.admin')

@section('title', 'Edit Subscription Plan')
@section('page-title', 'Edit Subscription Plan')

@section('content')
<div class="max-w-4xl mx-auto">
    <form method="POST" action="{{ route('admin.subscription-plans.update', $subscriptionPlan) }}" class="space-y-6">
        @csrf
        @method('PUT')

        <div class="bg-white shadow-md rounded-lg p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Plan Details</h3>

            <div class="space-y-4">
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700 mb-1">
                        Plan Name <span class="text-red-500">*</span>
                    </label>
                    <input type="text" name="name" id="name" 
                           value="{{ old('name', $subscriptionPlan->name) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-purple-500 focus:border-purple-500"
                           required>
                    @error('name')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="slug" class="block text-sm font-medium text-gray-700 mb-1">
                        Slug <span class="text-red-500">*</span>
                    </label>
                    <input type="text" name="slug" id="slug" 
                           value="{{ old('slug', $subscriptionPlan->slug) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-purple-500 focus:border-purple-500"
                           required>
                    <p class="mt-1 text-xs text-gray-500">Unique identifier (lowercase, no spaces)</p>
                    @error('slug')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="description" class="block text-sm font-medium text-gray-700 mb-1">
                        Description
                    </label>
                    <textarea name="description" id="description" rows="3"
                              class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-purple-500 focus:border-purple-500">{{ old('description', $subscriptionPlan->description) }}</textarea>
                    @error('description')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>
        </div>

        <div class="bg-white shadow-md rounded-lg p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Pricing</h3>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label for="price" class="block text-sm font-medium text-gray-700 mb-1">
                        Price <span class="text-red-500">*</span>
                    </label>
                    <input type="number" name="price" id="price" step="0.01" min="0"
                           value="{{ old('price', $subscriptionPlan->price) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-purple-500 focus:border-purple-500"
                           required>
                    @error('price')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="currency" class="block text-sm font-medium text-gray-700 mb-1">
                        Currency <span class="text-red-500">*</span>
                    </label>
                    <input type="text" name="currency" id="currency" maxlength="3"
                           value="{{ old('currency', $subscriptionPlan->currency) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-purple-500 focus:border-purple-500 uppercase"
                           required>
                    @error('currency')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="trial_days" class="block text-sm font-medium text-gray-700 mb-1">
                        Trial Days
                    </label>
                    <input type="number" name="trial_days" id="trial_days" min="0" max="365"
                           value="{{ old('trial_days', $subscriptionPlan->trial_days) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-purple-500 focus:border-purple-500">
                    @error('trial_days')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>
        </div>

        <div class="bg-white shadow-md rounded-lg p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Features</h3>
            <p class="text-sm text-gray-600 mb-4">Select the features included in this plan:</p>

            <div class="space-y-3">
                @php
                    $allFeatures = [
                        'view_assignments' => 'View Assignments',
                        'add_assignments' => 'Add Assignments',
                        'view_deadlines' => 'View Deadlines, Modules & Tutors',
                        'automated_reminders' => 'Automated Reminders',
                        'carry_over_automation' => 'Auto Carry-Over Missed Sessions',
                        'whatsapp_notifications' => 'WhatsApp Notifications',
                        'weekly_risk_warnings' => 'Weekly Risk Warnings',
                        'customizable_quiet_hours' => 'Customizable Quiet Hours',
                        'in_app_notifications' => 'In-App Notifications',
                        'assignment_history' => 'Assignment History & Tracking',
                    ];
                    $selectedFeatures = old('features', $subscriptionPlan->features ?: []);
                @endphp

                @foreach($allFeatures as $key => $label)
                <div class="flex items-center">
                    <input type="checkbox" name="features[]" id="feature_{{ $key }}" value="{{ $key }}"
                           {{ in_array($key, $selectedFeatures) ? 'checked' : '' }}
                           class="rounded border-gray-300 text-purple-600 focus:ring-purple-500">
                    <label for="feature_{{ $key }}" class="ml-2 text-sm text-gray-700">
                        {{ $label }}
                    </label>
                </div>
                @endforeach
            </div>

            <p class="mt-4 text-xs text-gray-500">
                <strong>Note:</strong> Features like "Automated Reminders", "Carry-Over Automation", "WhatsApp Notifications", and "Weekly Risk Warnings" are typically premium features (Paid/Trial Only).
            </p>
            @error('features')
                <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
            @enderror
        </div>

        <div class="bg-white shadow-md rounded-lg p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Settings</h3>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label for="sort_order" class="block text-sm font-medium text-gray-700 mb-1">
                        Sort Order
                    </label>
                    <input type="number" name="sort_order" id="sort_order" min="0"
                           value="{{ old('sort_order', $subscriptionPlan->sort_order) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-purple-500 focus:border-purple-500">
                    <p class="mt-1 text-xs text-gray-500">Lower numbers appear first</p>
                    @error('sort_order')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div class="flex items-center">
                    <input type="checkbox" name="is_active" id="is_active" value="1" 
                           {{ old('is_active', $subscriptionPlan->is_active) ? 'checked' : '' }}
                           class="rounded border-gray-300 text-purple-600 focus:ring-purple-500">
                    <label for="is_active" class="ml-2 text-sm text-gray-700">
                        Active (visible to users)
                    </label>
                </div>
            </div>
        </div>

        <div class="flex justify-end space-x-4">
            <a href="{{ route('admin.subscription-plans.index') }}" class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50">
                Cancel
            </a>
            <button type="submit" class="px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700">
                Update Plan
            </button>
        </div>
    </form>
</div>
@endsection
