@extends('layouts.admin')

@section('title', 'Subscription Details')
@section('page-title', 'Subscription Management - {{ $user->name }}')

@section('content')
<div class="max-w-4xl mx-auto">
    <!-- User Info Card -->
    <div class="bg-white shadow-md rounded-lg p-6 mb-6">
        <div class="flex items-center justify-between mb-4">
            <div class="flex items-center">
                <div class="w-16 h-16 rounded-full bg-blue-500 flex items-center justify-center text-white font-bold text-2xl mr-4">
                    {{ strtoupper(substr($user->name, 0, 1)) }}
                </div>
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">{{ $user->name }}</h1>
                    <p class="text-gray-600">{{ $user->email }}</p>
                </div>
            </div>
            <div>
                <span class="px-3 py-1 rounded-full text-sm font-semibold {{ $user->subscription_status === 'paid' ? 'bg-green-100 text-green-800' : ($user->subscription_status === 'trial' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800') }}">
                    {{ ucfirst($user->subscription_status) }}
                </span>
            </div>
        </div>
    </div>

    <!-- Update Subscription Status -->
    <div class="bg-white shadow-md rounded-lg p-6 mb-6">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Update Subscription Status</h2>
        <form method="POST" action="{{ route('admin.subscriptions.update-status', $user) }}" class="space-y-4">
            @csrf
            @method('PUT')
            
            <div>
                <label for="subscription_status" class="block text-sm font-medium text-gray-700 mb-1">
                    Subscription Status
                </label>
                <select name="subscription_status" id="subscription_status" 
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500"
                        required>
                    <option value="trial" {{ $user->subscription_status === 'trial' ? 'selected' : '' }}>Trial</option>
                    <option value="free" {{ $user->subscription_status === 'free' ? 'selected' : '' }}>Free</option>
                    <option value="paid" {{ $user->subscription_status === 'paid' ? 'selected' : '' }}>Paid</option>
                </select>
            </div>

            <div id="trial_date_field" style="display: none;">
                <label for="trial_expiry_date" class="block text-sm font-medium text-gray-700 mb-1">
                    Trial Expiry Date (Optional - defaults to system trial duration)
                </label>
                <input type="date" name="trial_expiry_date" id="trial_expiry_date" 
                       value="{{ $user->trial_expiry_date ? $user->trial_expiry_date->format('Y-m-d') : '' }}"
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500">
            </div>

            <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                Update Status
            </button>
        </form>
    </div>

    <!-- Quick Actions -->
    <div class="bg-white shadow-md rounded-lg p-6 mb-6">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Quick Actions</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            @if($user->subscription_status === 'trial')
            <form method="POST" action="{{ route('admin.subscriptions.extend-trial', $user) }}" class="inline">
                @csrf
                <div class="flex items-center space-x-2">
                    <input type="number" name="additional_days" value="7" min="1" max="365" 
                           class="w-20 px-2 py-1 border border-gray-300 rounded text-sm">
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 text-sm">
                        Extend Trial
                    </button>
                </div>
            </form>
            @endif

            @if($user->subscription_status !== 'paid')
            <form method="POST" action="{{ route('admin.subscriptions.grant-paid', $user) }}" class="inline">
                @csrf
                <button type="submit" class="w-full px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 text-sm"
                        onclick="return confirm('Grant paid subscription to this user?')">
                    Grant Paid Subscription
                </button>
            </form>
            @endif

            @if($user->subscription_status !== 'free')
            <form method="POST" action="{{ route('admin.subscriptions.revoke', $user) }}" class="inline">
                @csrf
                <button type="submit" class="w-full px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 text-sm"
                        onclick="return confirm('Revoke subscription and set to free?')">
                    Revoke Subscription
                </button>
            </form>
            @endif
        </div>
    </div>

    <!-- Subscription Details -->
    <div class="bg-white shadow-md rounded-lg p-6">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Subscription Details</h2>
        <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <dt class="text-sm font-medium text-gray-500">Current Status</dt>
                <dd class="mt-1 text-sm text-gray-900">{{ ucfirst($user->subscription_status) }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500">Trial Start Date</dt>
                <dd class="mt-1 text-sm text-gray-900">{{ $user->trial_start_date ? $user->trial_start_date->format('M d, Y') : 'N/A' }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500">Trial Expiry Date</dt>
                <dd class="mt-1 text-sm text-gray-900">
                    @if($user->trial_expiry_date)
                        {{ $user->trial_expiry_date->format('M d, Y') }}
                        @if($user->trial_expiry_date->isPast())
                            <span class="text-red-600">(Expired)</span>
                        @else
                            <span class="text-green-600">({{ $user->trial_expiry_date->diffForHumans() }})</span>
                        @endif
                    @else
                        N/A
                    @endif
                </dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500">Can Receive Automated Features</dt>
                <dd class="mt-1 text-sm text-gray-900">
                    <span class="px-2 py-1 rounded-full text-xs font-semibold {{ $user->canReceiveAutomatedFeatures() ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                        {{ $user->canReceiveAutomatedFeatures() ? 'Yes' : 'No' }}
                    </span>
                </dd>
            </div>
        </dl>
    </div>

    <div class="mt-6">
        <a href="{{ route('admin.subscriptions') }}" class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700">
            Back to All Subscriptions
        </a>
    </div>
</div>

<script>
    document.getElementById('subscription_status').addEventListener('change', function() {
        const trialField = document.getElementById('trial_date_field');
        if (this.value === 'trial') {
            trialField.style.display = 'block';
        } else {
            trialField.style.display = 'none';
        }
    });
    
    // Trigger on page load
    document.getElementById('subscription_status').dispatchEvent(new Event('change'));
</script>
@endsection
