@extends('layouts.admin')

@section('title', 'System Settings')
@section('page-title', 'System Settings')

@section('content')
<div class="max-w-4xl mx-auto">
    <form method="POST" action="{{ route('admin.settings.update') }}" class="space-y-6">
        @csrf
        @method('PUT')

        <!-- WhatsApp/Wasender Settings -->
        <div class="bg-white shadow-md rounded-lg p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                <svg class="w-5 h-5 mr-2 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                </svg>
                WhatsApp / Wasender API Settings
            </h3>

            <div class="space-y-4">
                <div>
                    <label for="whatsapp_enabled" class="flex items-center">
                        <input type="checkbox" name="whatsapp_enabled" id="whatsapp_enabled" value="1" 
                               {{ $settings['whatsapp_enabled'] ? 'checked' : '' }}
                               class="rounded border-gray-300 text-green-600 focus:ring-green-500">
                        <span class="ml-2 text-sm text-gray-700">Enable WhatsApp Notifications</span>
                    </label>
                    <p class="mt-1 text-xs text-gray-500">Globally enable/disable WhatsApp notifications for all users</p>
                </div>

                <div>
                    <label for="wasender_api_key" class="block text-sm font-medium text-gray-700 mb-1">
                        Wasender API Key
                    </label>
                    <input type="text" name="wasender_api_key" id="wasender_api_key" 
                           value="{{ old('wasender_api_key', $settings['wasender_api_key']) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-green-500 focus:border-green-500"
                           placeholder="Enter your Wasender API key">
                    <p class="mt-1 text-xs text-gray-500">Your Wasender API key for sending WhatsApp messages</p>
                    @error('wasender_api_key')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="wasender_api_url" class="block text-sm font-medium text-gray-700 mb-1">
                        Wasender API URL
                    </label>
                    <input type="url" name="wasender_api_url" id="wasender_api_url" 
                           value="{{ old('wasender_api_url', $settings['wasender_api_url']) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-green-500 focus:border-green-500"
                           required>
                    <p class="mt-1 text-xs text-gray-500">Base URL for Wasender API endpoint</p>
                    @error('wasender_api_url')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Test WhatsApp -->
                <div class="mt-4 p-4 bg-gray-50 rounded-lg border border-gray-200">
                    <h4 class="text-sm font-semibold text-gray-900 mb-2">Test WhatsApp Integration</h4>
                    <form method="POST" action="{{ route('admin.settings.test-whatsapp') }}" class="flex items-end space-x-2">
                        @csrf
                        <div class="flex-1">
                            <label for="test_phone" class="block text-xs font-medium text-gray-700 mb-1">
                                Phone Number (with country code, e.g., +1234567890)
                            </label>
                            <input type="text" name="test_phone" id="test_phone" 
                                   placeholder="+1234567890"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-green-500 focus:border-green-500 text-sm"
                                   required>
                        </div>
                        <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 text-sm whitespace-nowrap">
                            Send Test Message
                        </button>
                    </form>
                    <p class="mt-2 text-xs text-gray-500">Send a test WhatsApp message to verify your API configuration</p>
                </div>
            </div>
        </div>

        <!-- Trial & Subscription Settings -->
        <div class="bg-white shadow-md rounded-lg p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                <svg class="w-5 h-5 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                Trial & Subscription Settings
            </h3>

            <div class="space-y-4">
                <div>
                    <label for="trial_duration_days" class="block text-sm font-medium text-gray-700 mb-1">
                        Trial Duration (Days)
                    </label>
                    <input type="number" name="trial_duration_days" id="trial_duration_days" 
                           value="{{ old('trial_duration_days', $settings['trial_duration_days']) }}"
                           min="1" max="365"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500"
                           required>
                    <p class="mt-1 text-xs text-gray-500">Default trial period duration for new users (1-365 days)</p>
                    @error('trial_duration_days')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>
        </div>

        <!-- Quiet Hours Settings -->
        <div class="bg-white shadow-md rounded-lg p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                <svg class="w-5 h-5 mr-2 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                Default Quiet Hours
            </h3>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label for="default_quiet_hours_start" class="block text-sm font-medium text-gray-700 mb-1">
                        Quiet Hours Start
                    </label>
                    <input type="time" name="default_quiet_hours_start" id="default_quiet_hours_start" 
                           value="{{ old('default_quiet_hours_start', $settings['default_quiet_hours_start']) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-purple-500 focus:border-purple-500"
                           required>
                    <p class="mt-1 text-xs text-gray-500">Default start time (24-hour format)</p>
                    @error('default_quiet_hours_start')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="default_quiet_hours_end" class="block text-sm font-medium text-gray-700 mb-1">
                        Quiet Hours End
                    </label>
                    <input type="time" name="default_quiet_hours_end" id="default_quiet_hours_end" 
                           value="{{ old('default_quiet_hours_end', $settings['default_quiet_hours_end']) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-purple-500 focus:border-purple-500"
                           required>
                    <p class="mt-1 text-xs text-gray-500">Default end time (24-hour format)</p>
                    @error('default_quiet_hours_end')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>
        </div>

        <!-- Submit Button -->
        <div class="flex justify-end space-x-4">
            <a href="{{ route('admin.dashboard') }}" class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50">
                Cancel
            </a>
            <button type="submit" class="px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700">
                Save Settings
            </button>
        </div>
    </form>
</div>
@endsection
