<?php
/**
 * Run Migrations Script
 * 
 * INSTRUCTIONS:
 * 1. Upload this file to your public/ folder
 * 2. Visit: https://yourdomain.com/migrate.php?run=migrate
 * 3. Wait for completion
 * 4. DELETE THIS FILE IMMEDIATELY FOR SECURITY!
 */

if (!isset($_GET['run']) || $_GET['run'] !== 'migrate') {
    die('
    <h1>Run Migrations</h1>
    <p>To run migrations, add <code>?run=migrate</code> to the URL</p>
    <p><strong>Example:</strong> <code>https://yourdomain.com/migrate.php?run=migrate</code></p>
    <hr>
    <p><strong>⚠️ SECURITY WARNING:</strong> Delete this file after use!</p>
    ');
}

require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Run Migrations</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 50px auto; padding: 20px; }
        .success { color: #10b981; }
        .error { color: #ef4444; }
        pre { background: #f3f4f6; padding: 15px; border-radius: 5px; overflow-x: auto; }
        .warning { background: #fef3c7; border-left: 4px solid #f59e0b; padding: 15px; margin: 20px 0; }
    </style>
</head>
<body>
    <h1>🗄️ Running Database Migrations</h1>
    <pre><?php

try {
    $kernel->call('migrate', ['--force' => true]);
    echo "✓ Migrations completed successfully!\n";
    echo "\nAll database tables have been created.";
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n\n";
    echo "Common issues:\n";
    echo "- Database credentials incorrect in .env\n";
    echo "- Database doesn't exist\n";
    echo "- Database user doesn't have permissions\n";
    echo "\nCheck storage/logs/laravel.log for details.";
}

?></pre>

<div class="warning">
    <h2>⚠️ SECURITY WARNING</h2>
    <p><strong>IMPORTANT:</strong> Delete this file (<code>migrate.php</code>) immediately after use!</p>
</div>

</body>
</html>
