<?php
/**
 * Generate APP_KEY Script
 * 
 * INSTRUCTIONS:
 * 1. Upload this file to your public/ folder
 * 2. Visit: https://yourdomain.com/generate-key.php?run=key
 * 3. Copy the generated key to your .env file
 * 4. DELETE THIS FILE IMMEDIATELY FOR SECURITY!
 */

if (!isset($_GET['run']) || $_GET['run'] !== 'key') {
    die('
    <h1>Generate APP_KEY</h1>
    <p>To generate key, add <code>?run=key</code> to the URL</p>
    <p><strong>Example:</strong> <code>https://yourdomain.com/generate-key.php?run=key</code></p>
    <hr>
    <p><strong>⚠️ SECURITY WARNING:</strong> Delete this file after use!</p>
    ');
}

require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Generate APP_KEY</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 50px auto; padding: 20px; }
        .success { color: #10b981; background: #d1fae5; padding: 15px; border-radius: 5px; }
        pre { background: #f3f4f6; padding: 15px; border-radius: 5px; }
        .warning { background: #fef3c7; border-left: 4px solid #f59e0b; padding: 15px; margin: 20px 0; }
    </style>
</head>
<body>
    <h1>🔑 Generating APP_KEY</h1>
    <pre><?php

try {
    $kernel->call('key:generate', ['--force' => true]);
    echo "✓ APP_KEY generated successfully!\n\n";
    
    // Read .env file to show the key
    $envPath = __DIR__ . '/../.env';
    if (file_exists($envPath)) {
        $envContent = file_get_contents($envPath);
        if (preg_match('/APP_KEY=(.+)/', $envContent, $matches)) {
            echo "Your APP_KEY:\n";
            echo $matches[1] . "\n\n";
            echo "This has been saved to your .env file.";
        }
    }
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    echo "\nPlease check file permissions and .env file exists.";
}

?></pre>

<div class="warning">
    <h2>⚠️ SECURITY WARNING</h2>
    <p><strong>IMPORTANT:</strong> Delete this file (<code>generate-key.php</code>) immediately after use!</p>
</div>

</body>
</html>
