<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscription_plans', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // e.g., "Basic", "Premium", "Pro"
            $table->string('slug')->unique(); // e.g., "basic", "premium", "pro"
            $table->text('description')->nullable();
            $table->decimal('price', 10, 2); // Monthly price
            $table->string('currency', 3)->default('USD');
            $table->integer('trial_days')->default(0); // Trial period for this plan
            $table->json('features')->nullable(); // Array of features
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0); // For ordering plans
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscription_plans');
    }
};
