<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('system_settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->string('type')->default('string'); // string, boolean, integer, json
            $table->text('description')->nullable();
            $table->timestamps();
        });

        // Insert default settings
        DB::table('system_settings')->insert([
            [
                'key' => 'wasender_api_key',
                'value' => null,
                'type' => 'string',
                'description' => 'Wasender API Key for WhatsApp notifications',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'wasender_api_url',
                'value' => 'https://api.wasender.com',
                'type' => 'string',
                'description' => 'Wasender API URL',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'trial_duration_days',
                'value' => '14',
                'type' => 'integer',
                'description' => 'Trial period duration in days',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'default_quiet_hours_start',
                'value' => '18:00',
                'type' => 'string',
                'description' => 'Default quiet hours start time (HH:mm)',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'default_quiet_hours_end',
                'value' => '08:00',
                'type' => 'string',
                'description' => 'Default quiet hours end time (HH:mm)',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'whatsapp_enabled',
                'value' => '1',
                'type' => 'boolean',
                'description' => 'Enable/Disable WhatsApp notifications globally',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('system_settings');
    }
};
