<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_preferences', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->unique()->constrained()->onDelete('cascade');
            $table->time('quiet_hours_start')->default('18:00:00'); // 6:00 PM
            $table->time('quiet_hours_end')->default('08:00:00'); // 8:00 AM
            $table->string('university')->nullable();
            $table->string('course')->nullable();
            $table->integer('year_of_study')->nullable();
            $table->text('study_habits')->nullable(); // JSON or text
            $table->boolean('onboarding_completed')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_preferences');
    }
};
