<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('assignments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('module_name');
            $table->string('assignment_title');
            $table->string('tutor_name');
            $table->enum('assignment_type', ['weekly', 'formative', 'summative']);
            $table->date('due_date'); // Mandatory
            $table->date('planned_study_day'); // Mandatory
            $table->time('planned_study_time'); // Mandatory
            $table->enum('status', ['pending', 'completed'])->default('pending');
            $table->integer('week_start')->nullable(); // For formative/summative
            $table->integer('week_end')->nullable(); // For formative/summative
            $table->integer('carry_over_count')->default(0); // Track how many times carried over
            $table->timestamp('last_carried_over_at')->nullable();
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['user_id', 'due_date']);
            $table->index(['user_id', 'status']);
            $table->index(['user_id', 'planned_study_day']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('assignments');
    }
};
