<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->date('trial_start_date')->nullable();
            $table->date('trial_expiry_date')->nullable();
            $table->enum('subscription_status', ['trial', 'free', 'paid'])->default('free');
            $table->string('phone')->nullable()->unique();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['trial_start_date', 'trial_expiry_date', 'subscription_status', 'phone']);
        });
    }
};
