<?php

namespace App\Jobs;

use App\Models\User;
use App\Services\NotificationService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Support\Facades\Log;

class WeeklyRiskJob implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new job instance.
     */
    public function __construct(
        private ?User $user = null
    ) {}

    /**
     * Execute the job.
     * Run at end of week to check for risk warnings.
     */
    public function handle(NotificationService $notificationService): void
    {
        if ($this->user) {
            // Process single user
            if ($this->user->canReceiveAutomatedFeatures()) {
                $notificationService->sendWeeklyRiskWarning($this->user);
            }
        } else {
            // Process all users with active subscriptions
            $users = \App\Models\User::whereIn('subscription_status', ['trial', 'paid'])
                ->get();

            foreach ($users as $user) {
                if ($user->canReceiveAutomatedFeatures()) {
                    $notificationService->sendWeeklyRiskWarning($user);
                }
            }

            Log::info('Weekly risk warnings processed for all eligible users');
        }
    }
}
