<?php

namespace App\Jobs;

use App\Models\Assignment;
use App\Services\NotificationService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Support\Facades\Log;

class SendStudyReminderJob implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new job instance.
     */
    public function __construct(
        private Assignment $assignment
    ) {}

    /**
     * Execute the job.
     */
    public function handle(NotificationService $notificationService): void
    {
        $user = $this->assignment->user;

        if (!$user->canReceiveAutomatedFeatures()) {
            return;
        }

        // Check if it's time for the reminder (send 15 minutes before planned time)
        $plannedTime = $this->assignment->getPlannedStudyDateTime();
        $reminderTime = $plannedTime->copy()->subMinutes(15);

        if (now()->greaterThanOrEqualTo($reminderTime) && now()->lessThan($plannedTime)) {
            $notificationService->sendStudyReminder($this->assignment);
            Log::info("Study reminder sent for assignment {$this->assignment->id}");
        }
    }
}
