<?php

namespace App\Jobs;

use App\Models\Assignment;
use App\Services\NotificationService;
use App\Services\WhatsAppService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Support\Facades\Log;

class EscalationJob implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new job instance.
     */
    public function __construct(
        private Assignment $assignment
    ) {}

    /**
     * Execute the job.
     */
    public function handle(NotificationService $notificationService, WhatsAppService $whatsAppService): void
    {
        $user = $this->assignment->user;

        if (!$user->canReceiveAutomatedFeatures()) {
            return;
        }

        // Send escalating notifications for overdue assignments
        if ($this->assignment->isOverdue()) {
            // In-app notification
            $notificationService->sendOverdueNotification($this->assignment);

            // WhatsApp notification (if phone verified)
            if ($user->phone) {
                $whatsAppService->sendOverdue($this->assignment);
            }

            Log::info("Escalation notification sent for assignment {$this->assignment->id}");
        }
    }
}
