<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckSubscriptionFeature
{
    /**
     * Handle an incoming request.
     * Blocks access to premium features for free users after trial expiry.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();

        if (!$user) {
            return redirect()->route('login');
        }

        // Check if user has active subscription (trial or paid)
        if (!$user->canReceiveAutomatedFeatures()) {
            // Free users can still view and add assignments, but not use automated features
            if ($request->routeIs('notifications.*') || 
                $request->routeIs('whatsapp.*') ||
                $request->routeIs('carry-over.*')) {
                return redirect()->route('weekly-planner')
                    ->with('error', 'This feature requires an active subscription. Please upgrade to continue.');
            }
        }

        return $next($request);
    }
}
