<?php

namespace App\Http\Controllers;

use App\Services\AssignmentService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WeeklyPlannerController extends Controller
{
    public function __construct(
        private AssignmentService $assignmentService
    ) {}

    /**
     * Display the weekly planner (default landing page).
     */
    public function index()
    {
        $user = Auth::user();
        
        // Check if onboarding is completed
        if (!$user->preferences || !$user->preferences->onboarding_completed) {
            return redirect()->route('onboarding.start');
        }

        $assignments = $this->assignmentService->getWeeklyAssignments($user);

        return view('weekly-planner.index', [
            'dueThisWeek' => $assignments['due_this_week'],
            'overdue' => $assignments['overdue'],
            'plannedThisWeek' => $assignments['planned_this_week'],
            'user' => $user,
        ]);
    }
}
