<?php

namespace App\Http\Controllers;

use App\Models\UserPreference;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class OnboardingController extends Controller
{
    /**
     * Show onboarding start page.
     */
    public function start()
    {
        $user = Auth::user();
        
        if ($user->preferences && $user->preferences->onboarding_completed) {
            return redirect()->route('weekly-planner');
        }

        return view('onboarding.start');
    }

    /**
     * Handle stress and overload validation.
     */
    public function validateStress(Request $request)
    {
        $request->validate([
            'stress_level' => 'required|integer|min:1|max:10',
            'overload_level' => 'required|integer|min:1|max:10',
        ]);

        // Store in session for now, will save to preferences
        $request->session()->put('onboarding.stress_level', $request->stress_level);
        $request->session()->put('onboarding.overload_level', $request->overload_level);

        return redirect()->route('onboarding.personalize');
    }

    /**
     * Show personalization form.
     */
    public function personalize()
    {
        return view('onboarding.personalize');
    }

    /**
     * Handle personalization data.
     */
    public function savePersonalization(Request $request)
    {
        $request->validate([
            'university' => 'required|string|max:255',
            'course' => 'required|string|max:255',
            'year_of_study' => 'required|integer|min:1|max:10',
            'study_habits' => 'nullable|string',
        ]);

        $user = Auth::user();
        
        $preferences = $user->preferences ?? new UserPreference(['user_id' => $user->id]);
        $preferences->university = $request->university;
        $preferences->course = $request->course;
        $preferences->year_of_study = $request->year_of_study;
        $preferences->study_habits = $request->study_habits;
        $preferences->onboarding_completed = true;
        $preferences->save();

        return redirect()->route('onboarding.create-first-assignment');
    }

    /**
     * Show forced first assignment creation.
     */
    public function createFirstAssignment()
    {
        return view('onboarding.create-first-assignment');
    }
}
