<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\PushNotificationService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DeviceTokenController extends Controller
{
    public function __construct(
        private PushNotificationService $pushService
    ) {}

    /**
     * Register device token for push notifications.
     */
    public function register(Request $request)
    {
        $request->validate([
            'token' => ['required', 'string'],
            'platform' => ['required', 'in:android,ios,web'],
            'device_id' => ['nullable', 'string'],
            'device_name' => ['nullable', 'string'],
        ]);

        $user = Auth::user();

        $deviceToken = $this->pushService->registerToken(
            $user,
            $request->token,
            $request->platform,
            $request->device_id,
            $request->device_name
        );

        return response()->json([
            'success' => true,
            'message' => 'Device token registered successfully',
            'device_token' => $deviceToken,
        ]);
    }

    /**
     * Unregister device token.
     */
    public function unregister(Request $request)
    {
        $request->validate([
            'token' => ['required', 'string'],
        ]);

        $this->pushService->unregisterToken($request->token);

        return response()->json([
            'success' => true,
            'message' => 'Device token unregistered successfully',
        ]);
    }
}
