<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;

class FixAdminUser extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'admin:fix {email=admin@admin.com}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fix admin status for a user';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $email = $this->argument('email');
        
        $user = User::where('email', $email)->first();
        
        if (!$user) {
            $this->error("User with email '{$email}' not found!");
            return 1;
        }

        $this->info("Found user: {$user->name} ({$user->email})");
        $this->info("Current is_admin value: " . var_export($user->is_admin, true));
        $this->info("Current is_admin type: " . gettype($user->is_admin));
        
        // Force update to ensure it's set to true
        $user->is_admin = true;
        $user->save();
        
        // Refresh to verify
        $user->refresh();
        
        $this->info("Updated is_admin value: " . var_export($user->is_admin, true));
        $this->info("isAdmin() method returns: " . var_export($user->isAdmin(), true));
        
        $this->newLine();
        $this->info("✓ User '{$user->name}' is now an admin!");
        $this->warn('Please logout and login again for changes to take effect.');
        
        return 0;
    }
}
